/****** Object:  StoredProcedure [dbo].[P_SNGPC_FECHAMENTO_INVENTARIO]    Script Date: 03/26/2014 10:46:14 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_SNGPC_FECHAMENTO_INVENTARIO]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_SNGPC_FECHAMENTO_INVENTARIO]
GO

CREATE PROCEDURE [dbo].[P_SNGPC_FECHAMENTO_INVENTARIO] (@CD_EMP INT, @CD_FILIAL INT)
AS
BEGIN
        /* LIMPAR AS TABELAS TEMPORARIAS DE USO, CASO NECESSARIO */
        BEGIN TRY
                DROP TABLE #SNGPC_HIST_MOVIMENTACOES_INVENTARIO;
        END TRY
        BEGIN CATCH
        END CATCH
        BEGIN TRY
                DROP TABLE #SNGPC_MOVIMENTACOES_INVENTARIO;
        END TRY
        BEGIN CATCH
        END CATCH
        BEGIN TRY
                DROP TABLE #SNGPC_FECHAMENTO_INVENTARIO;
        END TRY
        BEGIN CATCH
        END CATCH
        /* GERAR RELACAO DAS MOVIMENTACOES REFERENTES AO ULTIMO INVENTARIO */
        SELECT 
                H.*
        INTO #SNGPC_HIST_MOVIMENTACOES_INVENTARIO
        FROM SNGPC_HIST_MOV_LOTE H
        WHERE 
                        CD_EMP = @CD_EMP
                AND CD_FILIAL IN (SELECT CD_FILIAL FROM dbo.UFD_PRC_FILIAL_AGRUPADA(@CD_EMP, @CD_FILIAL))
                AND UPPER(TIPO_MOV) = 'INVENTARIO INICIAL'
                AND CONVERT(CHAR(10),H.DT_MOV,112) >=
                        (
                                SELECT
                                        TOP 1
                                        CONVERT(CHAR(10),RI.DT_REINICIO,112)
                                FROM EST_SNGPC_REINICIO_INVENTARIO RI
                                WHERE
                                                RI.CD_EMP = H.CD_EMP
                                        AND RI.CD_FILIAL = H.CD_FILIAL
                                ORDER BY
                                        CD_REINICIO DESC
                        )
        /* GERAR RELACAO DAS MOVIMENTACOES REFERENTES AO ULTIMO INVENTARIO */
        SELECT 
                CD_EMP
                , CD_FILIAL
                , CD_PROD
                , LOTE AS CD_LOTE
                , MAX(DT_MOV) ULT_MOV
        INTO #SNGPC_MOVIMENTACOES_INVENTARIO
        FROM #SNGPC_HIST_MOVIMENTACOES_INVENTARIO H
        GROUP BY 
                CD_EMP
                , CD_FILIAL
                , CD_PROD
                , LOTE
        ;
        /* FILTRAR A RELACAO DAS MOVIMENTACOES COM OS DADOS DO ESTOQUE DOS LOTES NAS FILIAIS */
        SELECT 
                TMP.CD_EMP
                , TMP.CD_FILIAL
                , TMP.CD_PROD
                , CPL.REGISTRO_MS
                , TMP.LOTE AS CD_LOTE
                , LOT.NR_LOTE AS LOTE
                , TMP.QT_MOV
                , LOT.VALIDADE
                , LOT.DT_ULT_ALT
                , LOT.NR_LOTE 
        INTO #SNGPC_FECHAMENTO_INVENTARIO
        FROM #SNGPC_HIST_MOVIMENTACOES_INVENTARIO TMP
                INNER JOIN #SNGPC_MOVIMENTACOES_INVENTARIO H ON 
                                H.CD_EMP = TMP.CD_EMP
                        AND H.CD_FILIAL = TMP.CD_FILIAL
                        AND H.CD_PROD = TMP.CD_PROD
                        AND H.CD_LOTE = TMP.LOTE
                        AND H.ULT_MOV = TMP.DT_MOV
                INNER JOIN EST_PROD PRD ON
                                PRD.CD_EMP = TMP.CD_EMP
                        AND PRD.CD_PROD = TMP.CD_PROD
                INNER JOIN EST_PROD_EST_SNGPC_LOTE_CPL CPL ON
                                CPL.CD_EMP = TMP.CD_EMP
                        AND CPL.CD_FILIAL = TMP.CD_FILIAL
                        AND CPL.CD_LOTE = TMP.LOTE
                INNER JOIN EST_PROD_EST_SNGPC_LOTE LOT ON
                        LOT.CD_EMP = TMP.CD_EMP
                        AND LOT.CD_LOTE = TMP.LOTE
        /* INCLUINDO OS DADOS FINAIS NECESSARIOS PARA GERACAO DO INVENTARIO */
        SELECT
                INV.*
                , PRD.DS_PROD AS APRESENTACAO
                , CASE
                        WHEN (COALESCE(PRD.ANTIBIOTICO, 0) = 1) AND (COALESCE(PRD.FLAG_PRODUTO_CONTROLADO, 0) = 0) THEN 1
                        WHEN (COALESCE(PRD.ANTIBIOTICO, 0) = 0) AND (COALESCE(PRD.FLAG_PRODUTO_CONTROLADO, 0) = 1) THEN 2
                        ELSE 0
                  END CLASSE_TERAPEUTICA
                , COALESCE(TP_UND_ANVISA, 0) TIPO_UNIDADE
        FROM #SNGPC_FECHAMENTO_INVENTARIO INV
        INNER JOIN EST_PROD PRD ON
                        PRD.CD_EMP = INV.CD_EMP
                AND PRD.CD_PROD = INV.CD_PROD
         INNER JOIN EST_PROD_EST_SNGPC SPRD ON
                        SPRD.CD_EMP = INV.CD_EMP
                AND SPRD.CD_PROD = INV.CD_PROD
      
        WHERE
           INV.CD_EMP = @CD_EMP
           AND INV.CD_FILIAL IN (SELECT CD_FILIAL FROM dbo.UFD_PRC_FILIAL_AGRUPADA(@CD_EMP, @CD_FILIAL))
           AND PRD.CONTROLE_SNGPC = 1
           AND COALESCE(SPRD.PROD_INCONSISTENTE_ANVISA,0 ) <> 1
        ORDER BY 
                inv.CD_EMP
                , inv.CD_FILIAL
                , inv.CD_PROD
                , inv.LOTE
END
GO